// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.AI.Language.Text
{
    internal static partial class HealthcareAssertionAssociationExtensions
    {
        public static string ToSerialString(this HealthcareAssertionAssociation value) => value switch
        {
            HealthcareAssertionAssociation.Subject => "subject",
            HealthcareAssertionAssociation.Other => "other",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown HealthcareAssertionAssociation value.")
        };

        public static HealthcareAssertionAssociation ToHealthcareAssertionAssociation(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "subject")) return HealthcareAssertionAssociation.Subject;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "other")) return HealthcareAssertionAssociation.Other;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown HealthcareAssertionAssociation value.");
        }
    }
}
