// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Text
{
    /// <summary> Assertion of the entity. </summary>
    public partial class HealthcareAssertion
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HealthcareAssertion"/>. </summary>
        internal HealthcareAssertion()
        {
        }

        /// <summary> Initializes a new instance of <see cref="HealthcareAssertion"/>. </summary>
        /// <param name="conditionality"> Describes any conditionality on the entity. </param>
        /// <param name="certainty"> Describes the entities certainty and polarity. </param>
        /// <param name="association"> Describes if the entity is the subject of the text or if it describes someone else. </param>
        /// <param name="temporality"> Describes temporal information regarding the entity. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HealthcareAssertion(HealthcareAssertionConditionality? conditionality, HealthcareAssertionCertainty? certainty, HealthcareAssertionAssociation? association, HealthcareAssertionTemporality? temporality, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Conditionality = conditionality;
            Certainty = certainty;
            Association = association;
            Temporality = temporality;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Describes any conditionality on the entity. </summary>
        public HealthcareAssertionConditionality? Conditionality { get; }
        /// <summary> Describes the entities certainty and polarity. </summary>
        public HealthcareAssertionCertainty? Certainty { get; }
        /// <summary> Describes if the entity is the subject of the text or if it describes someone else. </summary>
        public HealthcareAssertionAssociation? Association { get; }
        /// <summary> Describes temporal information regarding the entity. </summary>
        public HealthcareAssertionTemporality? Temporality { get; }
    }
}
