// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.AI.Language.Text
{
    public partial class HealthcareAssertion : IUtf8JsonSerializable, IJsonModel<HealthcareAssertion>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<HealthcareAssertion>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<HealthcareAssertion>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HealthcareAssertion>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(HealthcareAssertion)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(Conditionality))
            {
                writer.WritePropertyName("conditionality"u8);
                writer.WriteStringValue(Conditionality.Value.ToSerialString());
            }
            if (Optional.IsDefined(Certainty))
            {
                writer.WritePropertyName("certainty"u8);
                writer.WriteStringValue(Certainty.Value.ToSerialString());
            }
            if (Optional.IsDefined(Association))
            {
                writer.WritePropertyName("association"u8);
                writer.WriteStringValue(Association.Value.ToSerialString());
            }
            if (Optional.IsDefined(Temporality))
            {
                writer.WritePropertyName("temporality"u8);
                writer.WriteStringValue(Temporality.Value.ToSerialString());
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        HealthcareAssertion IJsonModel<HealthcareAssertion>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HealthcareAssertion>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(HealthcareAssertion)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeHealthcareAssertion(document.RootElement, options);
        }

        internal static HealthcareAssertion DeserializeHealthcareAssertion(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            HealthcareAssertionConditionality? conditionality = default;
            HealthcareAssertionCertainty? certainty = default;
            HealthcareAssertionAssociation? association = default;
            HealthcareAssertionTemporality? temporality = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("conditionality"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    conditionality = property.Value.GetString().ToHealthcareAssertionConditionality();
                    continue;
                }
                if (property.NameEquals("certainty"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    certainty = property.Value.GetString().ToHealthcareAssertionCertainty();
                    continue;
                }
                if (property.NameEquals("association"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    association = property.Value.GetString().ToHealthcareAssertionAssociation();
                    continue;
                }
                if (property.NameEquals("temporality"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    temporality = property.Value.GetString().ToHealthcareAssertionTemporality();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new HealthcareAssertion(conditionality, certainty, association, temporality, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<HealthcareAssertion>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HealthcareAssertion>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(HealthcareAssertion)} does not support writing '{options.Format}' format.");
            }
        }

        HealthcareAssertion IPersistableModel<HealthcareAssertion>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HealthcareAssertion>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeHealthcareAssertion(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(HealthcareAssertion)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<HealthcareAssertion>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static HealthcareAssertion FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeHealthcareAssertion(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
