// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.Language.Text
{
    /// <summary> The FHIR Spec version. </summary>
    public readonly partial struct FhirVersion : IEquatable<FhirVersion>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FhirVersion"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FhirVersion(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string _401Value = "4.0.1";

        /// <summary> Version 4.0.1. </summary>
        public static FhirVersion _401 { get; } = new FhirVersion(_401Value);
        /// <summary> Determines if two <see cref="FhirVersion"/> values are the same. </summary>
        public static bool operator ==(FhirVersion left, FhirVersion right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FhirVersion"/> values are not the same. </summary>
        public static bool operator !=(FhirVersion left, FhirVersion right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FhirVersion"/>. </summary>
        public static implicit operator FhirVersion(string value) => new FhirVersion(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FhirVersion other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FhirVersion other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
