// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Text
{
    /// <summary> Represents an extracted sentences from the input document. </summary>
    public partial class ExtractedSummarySentence
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ExtractedSummarySentence"/>. </summary>
        /// <param name="text"> The extracted sentence text. </param>
        /// <param name="rankScore"> A double value representing the relevance of the sentence within the summary. Higher values indicate higher importance. </param>
        /// <param name="offset"> The sentence offset from the start of the document, based on the value of the parameter StringIndexType. </param>
        /// <param name="length"> The length of the sentence. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="text"/> is null. </exception>
        internal ExtractedSummarySentence(string text, double rankScore, int offset, int length)
        {
            Argument.AssertNotNull(text, nameof(text));

            Text = text;
            RankScore = rankScore;
            Offset = offset;
            Length = length;
        }

        /// <summary> Initializes a new instance of <see cref="ExtractedSummarySentence"/>. </summary>
        /// <param name="text"> The extracted sentence text. </param>
        /// <param name="rankScore"> A double value representing the relevance of the sentence within the summary. Higher values indicate higher importance. </param>
        /// <param name="offset"> The sentence offset from the start of the document, based on the value of the parameter StringIndexType. </param>
        /// <param name="length"> The length of the sentence. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ExtractedSummarySentence(string text, double rankScore, int offset, int length, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Text = text;
            RankScore = rankScore;
            Offset = offset;
            Length = length;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ExtractedSummarySentence"/> for deserialization. </summary>
        internal ExtractedSummarySentence()
        {
        }

        /// <summary> The extracted sentence text. </summary>
        public string Text { get; }
        /// <summary> A double value representing the relevance of the sentence within the summary. Higher values indicate higher importance. </summary>
        public double RankScore { get; }
        /// <summary> The sentence offset from the start of the document, based on the value of the parameter StringIndexType. </summary>
        public int Offset { get; }
        /// <summary> The length of the sentence. </summary>
        public int Length { get; }
    }
}
