// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Text
{
    /// <summary> Contains the analyze text Entity linking task LRO result. </summary>
    public partial class EntityLinkingOperationResult : AnalyzeTextOperationResult
    {
        /// <summary> Initializes a new instance of <see cref="EntityLinkingOperationResult"/>. </summary>
        /// <param name="lastUpdateDateTime"> The last updated time in UTC for the task. </param>
        /// <param name="status"> The status of the task at the mentioned last update time. </param>
        /// <param name="results"> Entity linking result. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="results"/> is null. </exception>
        internal EntityLinkingOperationResult(DateTimeOffset lastUpdateDateTime, TextActionState status, EntityLinkingResult results) : base(lastUpdateDateTime, status)
        {
            Argument.AssertNotNull(results, nameof(results));

            Kind = AnalyzeTextOperationResultsKind.EntityLinkingOperationResults;
            Results = results;
        }

        /// <summary> Initializes a new instance of <see cref="EntityLinkingOperationResult"/>. </summary>
        /// <param name="lastUpdateDateTime"> The last updated time in UTC for the task. </param>
        /// <param name="status"> The status of the task at the mentioned last update time. </param>
        /// <param name="name"> task name. </param>
        /// <param name="kind"> Kind of the task. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="results"> Entity linking result. </param>
        internal EntityLinkingOperationResult(DateTimeOffset lastUpdateDateTime, TextActionState status, string name, AnalyzeTextOperationResultsKind kind, IDictionary<string, BinaryData> serializedAdditionalRawData, EntityLinkingResult results) : base(lastUpdateDateTime, status, name, kind, serializedAdditionalRawData)
        {
            Results = results;
        }

        /// <summary> Initializes a new instance of <see cref="EntityLinkingOperationResult"/> for deserialization. </summary>
        internal EntityLinkingOperationResult()
        {
        }

        /// <summary> Entity linking result. </summary>
        public EntityLinkingResult Results { get; }
    }
}
