// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Text
{
    /// <summary> Contains the analyze text Entity linking LRO task. </summary>
    public partial class EntityLinkingOperationAction : AnalyzeTextOperationAction
    {
        /// <summary> Initializes a new instance of <see cref="EntityLinkingOperationAction"/>. </summary>
        public EntityLinkingOperationAction()
        {
            Kind = AnalyzeTextOperationActionKind.EntityLinking;
        }

        /// <summary> Initializes a new instance of <see cref="EntityLinkingOperationAction"/>. </summary>
        /// <param name="name"> task name. </param>
        /// <param name="kind"> The kind of task to perform. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="actionContent"> Task parameters. </param>
        internal EntityLinkingOperationAction(string name, AnalyzeTextOperationActionKind kind, IDictionary<string, BinaryData> serializedAdditionalRawData, EntityLinkingActionContent actionContent) : base(name, kind, serializedAdditionalRawData)
        {
            ActionContent = actionContent;
        }

        /// <summary> Task parameters. </summary>
        public EntityLinkingActionContent ActionContent { get; set; }
    }
}
