// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.Language.Text
{
    /// <summary> Kind of entity components supported. </summary>
    internal readonly partial struct EntityComponentKind : IEquatable<EntityComponentKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EntityComponentKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EntityComponentKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PrebuiltComponentValue = "PrebuiltComponent";
        private const string LearnedComponentValue = "LearnedComponent";
        private const string ListComponentValue = "ListComponent";

        /// <summary> Prebuilt component. </summary>
        public static EntityComponentKind PrebuiltComponent { get; } = new EntityComponentKind(PrebuiltComponentValue);
        /// <summary> Learned component. </summary>
        public static EntityComponentKind LearnedComponent { get; } = new EntityComponentKind(LearnedComponentValue);
        /// <summary> List component. </summary>
        public static EntityComponentKind ListComponent { get; } = new EntityComponentKind(ListComponentValue);
        /// <summary> Determines if two <see cref="EntityComponentKind"/> values are the same. </summary>
        public static bool operator ==(EntityComponentKind left, EntityComponentKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EntityComponentKind"/> values are not the same. </summary>
        public static bool operator !=(EntityComponentKind left, EntityComponentKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EntityComponentKind"/>. </summary>
        public static implicit operator EntityComponentKind(string value) => new EntityComponentKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EntityComponentKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EntityComponentKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
