// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Text
{
    /// <summary> An object representing the task definition for an Entities Recognition task. </summary>
    public partial class EntitiesOperationAction : AnalyzeTextOperationAction
    {
        /// <summary> Initializes a new instance of <see cref="EntitiesOperationAction"/>. </summary>
        public EntitiesOperationAction()
        {
            Kind = AnalyzeTextOperationActionKind.EntityRecognition;
        }

        /// <summary> Initializes a new instance of <see cref="EntitiesOperationAction"/>. </summary>
        /// <param name="name"> task name. </param>
        /// <param name="kind"> The kind of task to perform. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="actionContent"> Task parameters. </param>
        internal EntitiesOperationAction(string name, AnalyzeTextOperationActionKind kind, IDictionary<string, BinaryData> serializedAdditionalRawData, EntitiesActionContent actionContent) : base(name, kind, serializedAdditionalRawData)
        {
            ActionContent = actionContent;
        }

        /// <summary> Task parameters. </summary>
        public EntitiesActionContent ActionContent { get; set; }
    }
}
