// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Text
{
    /// <summary> Supported parameters for an Entity Recognition task. </summary>
    public partial class EntitiesActionContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="EntitiesActionContent"/>. </summary>
        public EntitiesActionContent()
        {
            Inclusions = new ChangeTrackingList<EntityCategory>();
            Exclusions = new ChangeTrackingList<EntityCategory>();
        }

        /// <summary> Initializes a new instance of <see cref="EntitiesActionContent"/>. </summary>
        /// <param name="loggingOptOut"> logging opt out. </param>
        /// <param name="modelVersion"> model version. </param>
        /// <param name="stringIndexType"> (Optional) parameter to provide the string index type used to interpret string offsets. Defaults to TextElements (Graphemes). </param>
        /// <param name="inclusions"> (Optional) request parameter that limits the output to the requested entity types included in this list. We will apply inclusionList before exclusionList. </param>
        /// <param name="exclusions"> (Optional) request parameter that filters out any entities that are included the excludeList. When a user specifies an excludeList, they cannot get a prediction returned with an entity in that list. We will apply inclusionList before exclusionList. </param>
        /// <param name="overlapPolicy">
        /// (Optional) describes the type of overlap policy to apply to the ner output.
        /// Please note <see cref="EntityOverlapPolicy"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AllowOverlapEntityPolicyType"/> and <see cref="MatchLongestEntityPolicyType"/>.
        /// </param>
        /// <param name="inferenceOptions"> (Optional) request parameter that allows the user to provide settings for running the inference. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal EntitiesActionContent(bool? loggingOptOut, string modelVersion, StringIndexType? stringIndexType, IList<EntityCategory> inclusions, IList<EntityCategory> exclusions, EntityOverlapPolicy overlapPolicy, EntityInferenceConfig inferenceOptions, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            LoggingOptOut = loggingOptOut;
            ModelVersion = modelVersion;
            StringIndexType = stringIndexType;
            Inclusions = inclusions;
            Exclusions = exclusions;
            OverlapPolicy = overlapPolicy;
            InferenceOptions = inferenceOptions;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> logging opt out. </summary>
        public bool? LoggingOptOut { get; set; }
        /// <summary> model version. </summary>
        public string ModelVersion { get; set; }
        /// <summary> (Optional) parameter to provide the string index type used to interpret string offsets. Defaults to TextElements (Graphemes). </summary>
        public StringIndexType? StringIndexType { get; set; }
        /// <summary> (Optional) request parameter that limits the output to the requested entity types included in this list. We will apply inclusionList before exclusionList. </summary>
        public IList<EntityCategory> Inclusions { get; }
        /// <summary> (Optional) request parameter that filters out any entities that are included the excludeList. When a user specifies an excludeList, they cannot get a prediction returned with an entity in that list. We will apply inclusionList before exclusionList. </summary>
        public IList<EntityCategory> Exclusions { get; }
        /// <summary>
        /// (Optional) describes the type of overlap policy to apply to the ner output.
        /// Please note <see cref="EntityOverlapPolicy"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AllowOverlapEntityPolicyType"/> and <see cref="MatchLongestEntityPolicyType"/>.
        /// </summary>
        public EntityOverlapPolicy OverlapPolicy { get; set; }
        /// <summary> (Optional) request parameter that allows the user to provide settings for running the inference. </summary>
        public EntityInferenceConfig InferenceOptions { get; set; }
    }
}
