// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.AI.Language.Text
{
    internal static partial class DocumentSentimentExtensions
    {
        public static string ToSerialString(this DocumentSentiment value) => value switch
        {
            DocumentSentiment.Positive => "positive",
            DocumentSentiment.Neutral => "neutral",
            DocumentSentiment.Negative => "negative",
            DocumentSentiment.Mixed => "mixed",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DocumentSentiment value.")
        };

        public static DocumentSentiment ToDocumentSentiment(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "positive")) return DocumentSentiment.Positive;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "neutral")) return DocumentSentiment.Neutral;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "negative")) return DocumentSentiment.Negative;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "mixed")) return DocumentSentiment.Mixed;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DocumentSentiment value.");
        }
    }
}
