// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Text
{
    /// <summary> Contains the details of the detected language for the text. </summary>
    public partial class DetectedLanguage
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DetectedLanguage"/>. </summary>
        /// <param name="name"> Long name of a detected language (e.g. English, French). </param>
        /// <param name="iso6391Name"> A two letter representation of the detected language according to the ISO 639-1 standard (e.g. en, fr). </param>
        /// <param name="confidenceScore"> A confidence score between 0 and 1. Scores close to 1 indicate 100% certainty that the identified language is true. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> or <paramref name="iso6391Name"/> is null. </exception>
        internal DetectedLanguage(string name, string iso6391Name, double confidenceScore)
        {
            Argument.AssertNotNull(name, nameof(name));
            Argument.AssertNotNull(iso6391Name, nameof(iso6391Name));

            Name = name;
            Iso6391Name = iso6391Name;
            ConfidenceScore = confidenceScore;
        }

        /// <summary> Initializes a new instance of <see cref="DetectedLanguage"/>. </summary>
        /// <param name="name"> Long name of a detected language (e.g. English, French). </param>
        /// <param name="iso6391Name"> A two letter representation of the detected language according to the ISO 639-1 standard (e.g. en, fr). </param>
        /// <param name="confidenceScore"> A confidence score between 0 and 1. Scores close to 1 indicate 100% certainty that the identified language is true. </param>
        /// <param name="script"> Identifies the script of the input document. </param>
        /// <param name="scriptCode"> Identifies the script of the input document. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DetectedLanguage(string name, string iso6391Name, double confidenceScore, ScriptKind? script, ScriptCode? scriptCode, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            Iso6391Name = iso6391Name;
            ConfidenceScore = confidenceScore;
            Script = script;
            ScriptCode = scriptCode;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="DetectedLanguage"/> for deserialization. </summary>
        internal DetectedLanguage()
        {
        }

        /// <summary> Long name of a detected language (e.g. English, French). </summary>
        public string Name { get; }
        /// <summary> A two letter representation of the detected language according to the ISO 639-1 standard (e.g. en, fr). </summary>
        public string Iso6391Name { get; }
        /// <summary> A confidence score between 0 and 1. Scores close to 1 indicate 100% certainty that the identified language is true. </summary>
        public double ConfidenceScore { get; }
        /// <summary> Identifies the script of the input document. </summary>
        public ScriptKind? Script { get; }
        /// <summary> Identifies the script of the input document. </summary>
        public ScriptCode? ScriptCode { get; }
    }
}
