// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Text
{
    /// <summary> Represents the date value. </summary>
    public partial class DateValue
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DateValue"/>. </summary>
        /// <param name="timex"> An extended ISO 8601 date/time representation as described in (https://github.com/Microsoft/Recognizers-Text/blob/master/Patterns/English/English-DateTime.yaml). </param>
        /// <param name="value"> The actual time that the extracted text denote. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="timex"/> or <paramref name="value"/> is null. </exception>
        internal DateValue(string timex, string value)
        {
            Argument.AssertNotNull(timex, nameof(timex));
            Argument.AssertNotNull(value, nameof(value));

            Timex = timex;
            Value = value;
        }

        /// <summary> Initializes a new instance of <see cref="DateValue"/>. </summary>
        /// <param name="timex"> An extended ISO 8601 date/time representation as described in (https://github.com/Microsoft/Recognizers-Text/blob/master/Patterns/English/English-DateTime.yaml). </param>
        /// <param name="value"> The actual time that the extracted text denote. </param>
        /// <param name="modifier"> Modifier for datetime to indicate point of reference like before, after etc. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DateValue(string timex, string value, TemporalModifier? modifier, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Timex = timex;
            Value = value;
            Modifier = modifier;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="DateValue"/> for deserialization. </summary>
        internal DateValue()
        {
        }

        /// <summary> An extended ISO 8601 date/time representation as described in (https://github.com/Microsoft/Recognizers-Text/blob/master/Patterns/English/English-DateTime.yaml). </summary>
        public string Timex { get; }
        /// <summary> The actual time that the extracted text denote. </summary>
        public string Value { get; }
        /// <summary> Modifier for datetime to indicate point of reference like before, after etc. </summary>
        public TemporalModifier? Modifier { get; }
    }
}
