// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Text
{
    /// <summary> Use custom models to ease the process of sentiment analysis from documents like product reviews. </summary>
    public partial class CustomSentimentAnalysisOperationAction : AnalyzeTextOperationAction
    {
        /// <summary> Initializes a new instance of <see cref="CustomSentimentAnalysisOperationAction"/>. </summary>
        public CustomSentimentAnalysisOperationAction()
        {
            Kind = AnalyzeTextOperationActionKind.CustomSentimentAnalysis;
        }

        /// <summary> Initializes a new instance of <see cref="CustomSentimentAnalysisOperationAction"/>. </summary>
        /// <param name="name"> task name. </param>
        /// <param name="kind"> The kind of task to perform. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="actionContent"> Custom Sentiment Analysis task parameters. </param>
        internal CustomSentimentAnalysisOperationAction(string name, AnalyzeTextOperationActionKind kind, IDictionary<string, BinaryData> serializedAdditionalRawData, CustomSentimentAnalysisActionContent actionContent) : base(name, kind, serializedAdditionalRawData)
        {
            ActionContent = actionContent;
        }

        /// <summary> Custom Sentiment Analysis task parameters. </summary>
        public CustomSentimentAnalysisActionContent ActionContent { get; set; }
    }
}
