// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Text
{
    /// <summary> Contains the custom healthcare job result. </summary>
    public partial class CustomHealthcareOperationResult : AnalyzeTextOperationResult
    {
        /// <summary> Initializes a new instance of <see cref="CustomHealthcareOperationResult"/>. </summary>
        /// <param name="lastUpdateDateTime"> The last updated time in UTC for the task. </param>
        /// <param name="status"> The status of the task at the mentioned last update time. </param>
        /// <param name="results"> Contains the list of document results. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="results"/> is null. </exception>
        internal CustomHealthcareOperationResult(DateTimeOffset lastUpdateDateTime, TextActionState status, CustomHealthcareResult results) : base(lastUpdateDateTime, status)
        {
            Argument.AssertNotNull(results, nameof(results));

            Kind = AnalyzeTextOperationResultsKind.CustomHealthcareOperationResults;
            Results = results;
        }

        /// <summary> Initializes a new instance of <see cref="CustomHealthcareOperationResult"/>. </summary>
        /// <param name="lastUpdateDateTime"> The last updated time in UTC for the task. </param>
        /// <param name="status"> The status of the task at the mentioned last update time. </param>
        /// <param name="name"> task name. </param>
        /// <param name="kind"> Kind of the task. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="results"> Contains the list of document results. </param>
        internal CustomHealthcareOperationResult(DateTimeOffset lastUpdateDateTime, TextActionState status, string name, AnalyzeTextOperationResultsKind kind, IDictionary<string, BinaryData> serializedAdditionalRawData, CustomHealthcareResult results) : base(lastUpdateDateTime, status, name, kind, serializedAdditionalRawData)
        {
            Results = results;
        }

        /// <summary> Initializes a new instance of <see cref="CustomHealthcareOperationResult"/> for deserialization. </summary>
        internal CustomHealthcareOperationResult()
        {
        }

        /// <summary> Contains the list of document results. </summary>
        public CustomHealthcareResult Results { get; }
    }
}
