// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Text
{
    /// <summary> Contains the custom healthcare task definition. </summary>
    public partial class CustomHealthcareOperationAction : AnalyzeTextOperationAction
    {
        /// <summary> Initializes a new instance of <see cref="CustomHealthcareOperationAction"/>. </summary>
        public CustomHealthcareOperationAction()
        {
            Kind = AnalyzeTextOperationActionKind.CustomHealthcare;
        }

        /// <summary> Initializes a new instance of <see cref="CustomHealthcareOperationAction"/>. </summary>
        /// <param name="name"> task name. </param>
        /// <param name="kind"> The kind of task to perform. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="actionContent"> Contains the custom healthcare task parameters. </param>
        internal CustomHealthcareOperationAction(string name, AnalyzeTextOperationActionKind kind, IDictionary<string, BinaryData> serializedAdditionalRawData, CustomHealthcareActionContent actionContent) : base(name, kind, serializedAdditionalRawData)
        {
            ActionContent = actionContent;
        }

        /// <summary> Contains the custom healthcare task parameters. </summary>
        public CustomHealthcareActionContent ActionContent { get; set; }
    }
}
