// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Text
{
    /// <summary> An object representing the task definition for an Custom Abstractive Summarization task. </summary>
    public partial class CustomAbstractiveSummarizationOperationAction : AnalyzeTextOperationAction
    {
        /// <summary> Initializes a new instance of <see cref="CustomAbstractiveSummarizationOperationAction"/>. </summary>
        /// <param name="actionContent"> Parameters for the Custom Abstractive Summarization task. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="actionContent"/> is null. </exception>
        public CustomAbstractiveSummarizationOperationAction(CustomAbstractiveSummarizationActionContent actionContent)
        {
            Argument.AssertNotNull(actionContent, nameof(actionContent));

            Kind = AnalyzeTextOperationActionKind.CustomAbstractiveSummarization;
            ActionContent = actionContent;
        }

        /// <summary> Initializes a new instance of <see cref="CustomAbstractiveSummarizationOperationAction"/>. </summary>
        /// <param name="name"> task name. </param>
        /// <param name="kind"> The kind of task to perform. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="actionContent"> Parameters for the Custom Abstractive Summarization task. </param>
        internal CustomAbstractiveSummarizationOperationAction(string name, AnalyzeTextOperationActionKind kind, IDictionary<string, BinaryData> serializedAdditionalRawData, CustomAbstractiveSummarizationActionContent actionContent) : base(name, kind, serializedAdditionalRawData)
        {
            ActionContent = actionContent;
        }

        /// <summary> Initializes a new instance of <see cref="CustomAbstractiveSummarizationOperationAction"/> for deserialization. </summary>
        internal CustomAbstractiveSummarizationOperationAction()
        {
        }

        /// <summary> Parameters for the Custom Abstractive Summarization task. </summary>
        public CustomAbstractiveSummarizationActionContent ActionContent { get; }
    }
}
