// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Text.Json;
using Azure.Core;

namespace Azure.AI.Language.Text
{
    [PersistableModelProxy(typeof(UnknownBaseMetadata))]
    public partial class BaseMetadata : IUtf8JsonSerializable, IJsonModel<BaseMetadata>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<BaseMetadata>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<BaseMetadata>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BaseMetadata>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BaseMetadata)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("metadataKind"u8);
            writer.WriteStringValue(MetadataKind.ToString());
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        BaseMetadata IJsonModel<BaseMetadata>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BaseMetadata>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BaseMetadata)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeBaseMetadata(document.RootElement, options);
        }

        internal static BaseMetadata DeserializeBaseMetadata(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            if (element.TryGetProperty("metadataKind", out JsonElement discriminator))
            {
                switch (discriminator.GetString())
                {
                    case "AgeMetadata": return AgeMetadata.DeserializeAgeMetadata(element, options);
                    case "AreaMetadata": return AreaMetadata.DeserializeAreaMetadata(element, options);
                    case "CurrencyMetadata": return CurrencyMetadata.DeserializeCurrencyMetadata(element, options);
                    case "DateMetadata": return DateMetadata.DeserializeDateMetadata(element, options);
                    case "DateTimeMetadata": return DateTimeMetadata.DeserializeDateTimeMetadata(element, options);
                    case "InformationMetadata": return InformationMetadata.DeserializeInformationMetadata(element, options);
                    case "LengthMetadata": return LengthMetadata.DeserializeLengthMetadata(element, options);
                    case "NumberMetadata": return NumberMetadata.DeserializeNumberMetadata(element, options);
                    case "NumericRangeMetadata": return NumericRangeMetadata.DeserializeNumericRangeMetadata(element, options);
                    case "OrdinalMetadata": return OrdinalMetadata.DeserializeOrdinalMetadata(element, options);
                    case "SpeedMetadata": return SpeedMetadata.DeserializeSpeedMetadata(element, options);
                    case "TemperatureMetadata": return TemperatureMetadata.DeserializeTemperatureMetadata(element, options);
                    case "TemporalSetMetadata": return TemporalSetMetadata.DeserializeTemporalSetMetadata(element, options);
                    case "TemporalSpanMetadata": return TemporalSpanMetadata.DeserializeTemporalSpanMetadata(element, options);
                    case "TimeMetadata": return TimeMetadata.DeserializeTimeMetadata(element, options);
                    case "VolumeMetadata": return VolumeMetadata.DeserializeVolumeMetadata(element, options);
                    case "WeightMetadata": return WeightMetadata.DeserializeWeightMetadata(element, options);
                }
            }
            return UnknownBaseMetadata.DeserializeUnknownBaseMetadata(element, options);
        }

        BinaryData IPersistableModel<BaseMetadata>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BaseMetadata>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(BaseMetadata)} does not support writing '{options.Format}' format.");
            }
        }

        BaseMetadata IPersistableModel<BaseMetadata>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BaseMetadata>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeBaseMetadata(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(BaseMetadata)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<BaseMetadata>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static BaseMetadata FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeBaseMetadata(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
