// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.AI.Language.Text
{
    /// <summary> The AnalyzeTextSubmitJobRequest. </summary>
    internal partial class AnalyzeTextSubmitJobRequest
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AnalyzeTextSubmitJobRequest"/>. </summary>
        /// <param name="textInput"> Contains the input to be analyzed. </param>
        /// <param name="actions">
        /// List of tasks to be performed as part of the LRO.
        /// Please note <see cref="AnalyzeTextOperationAction"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AbstractiveSummarizationOperationAction"/>, <see cref="CustomAbstractiveSummarizationOperationAction"/>, <see cref="CustomEntitiesOperationAction"/>, <see cref="CustomHealthcareOperationAction"/>, <see cref="CustomMultiLabelClassificationOperationAction"/>, <see cref="CustomSentimentAnalysisOperationAction"/>, <see cref="CustomSingleLabelClassificationOperationAction"/>, <see cref="EntityLinkingOperationAction"/>, <see cref="EntitiesOperationAction"/>, <see cref="ExtractiveSummarizationOperationAction"/>, <see cref="HealthcareOperationAction"/>, <see cref="KeyPhraseOperationAction"/>, <see cref="PiiOperationAction"/> and <see cref="SentimentAnalysisOperationAction"/>.
        /// </param>
        /// <exception cref="ArgumentNullException"> <paramref name="textInput"/> or <paramref name="actions"/> is null. </exception>
        internal AnalyzeTextSubmitJobRequest(MultiLanguageTextInput textInput, IEnumerable<AnalyzeTextOperationAction> actions)
        {
            Argument.AssertNotNull(textInput, nameof(textInput));
            Argument.AssertNotNull(actions, nameof(actions));

            TextInput = textInput;
            Actions = actions.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="AnalyzeTextSubmitJobRequest"/>. </summary>
        /// <param name="displayName"> Name for the task. </param>
        /// <param name="textInput"> Contains the input to be analyzed. </param>
        /// <param name="actions">
        /// List of tasks to be performed as part of the LRO.
        /// Please note <see cref="AnalyzeTextOperationAction"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AbstractiveSummarizationOperationAction"/>, <see cref="CustomAbstractiveSummarizationOperationAction"/>, <see cref="CustomEntitiesOperationAction"/>, <see cref="CustomHealthcareOperationAction"/>, <see cref="CustomMultiLabelClassificationOperationAction"/>, <see cref="CustomSentimentAnalysisOperationAction"/>, <see cref="CustomSingleLabelClassificationOperationAction"/>, <see cref="EntityLinkingOperationAction"/>, <see cref="EntitiesOperationAction"/>, <see cref="ExtractiveSummarizationOperationAction"/>, <see cref="HealthcareOperationAction"/>, <see cref="KeyPhraseOperationAction"/>, <see cref="PiiOperationAction"/> and <see cref="SentimentAnalysisOperationAction"/>.
        /// </param>
        /// <param name="defaultLanguage"> Default language to use for records requesting automatic language detection. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AnalyzeTextSubmitJobRequest(string displayName, MultiLanguageTextInput textInput, IReadOnlyList<AnalyzeTextOperationAction> actions, string defaultLanguage, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DisplayName = displayName;
            TextInput = textInput;
            Actions = actions;
            DefaultLanguage = defaultLanguage;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="AnalyzeTextSubmitJobRequest"/> for deserialization. </summary>
        internal AnalyzeTextSubmitJobRequest()
        {
        }

        /// <summary> Name for the task. </summary>
        public string DisplayName { get; }
        /// <summary> Contains the input to be analyzed. </summary>
        public MultiLanguageTextInput TextInput { get; }
        /// <summary>
        /// List of tasks to be performed as part of the LRO.
        /// Please note <see cref="AnalyzeTextOperationAction"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AbstractiveSummarizationOperationAction"/>, <see cref="CustomAbstractiveSummarizationOperationAction"/>, <see cref="CustomEntitiesOperationAction"/>, <see cref="CustomHealthcareOperationAction"/>, <see cref="CustomMultiLabelClassificationOperationAction"/>, <see cref="CustomSentimentAnalysisOperationAction"/>, <see cref="CustomSingleLabelClassificationOperationAction"/>, <see cref="EntityLinkingOperationAction"/>, <see cref="EntitiesOperationAction"/>, <see cref="ExtractiveSummarizationOperationAction"/>, <see cref="HealthcareOperationAction"/>, <see cref="KeyPhraseOperationAction"/>, <see cref="PiiOperationAction"/> and <see cref="SentimentAnalysisOperationAction"/>.
        /// </summary>
        public IReadOnlyList<AnalyzeTextOperationAction> Actions { get; }
        /// <summary> Default language to use for records requesting automatic language detection. </summary>
        public string DefaultLanguage { get; }
    }
}
