// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Text
{
    /// <summary> Contains the analyze text SentimentAnalysis LRO task result. </summary>
    public partial class AnalyzeTextSentimentResult : AnalyzeTextResult
    {
        /// <summary> Initializes a new instance of <see cref="AnalyzeTextSentimentResult"/>. </summary>
        /// <param name="results"> The sentiment analysis results. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="results"/> is null. </exception>
        internal AnalyzeTextSentimentResult(SentimentResult results)
        {
            Argument.AssertNotNull(results, nameof(results));

            Kind = AnalyzeTextResultsKind.SentimentAnalysisResults;
            Results = results;
        }

        /// <summary> Initializes a new instance of <see cref="AnalyzeTextSentimentResult"/>. </summary>
        /// <param name="kind"> The kind of task result. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="results"> The sentiment analysis results. </param>
        internal AnalyzeTextSentimentResult(AnalyzeTextResultsKind kind, IDictionary<string, BinaryData> serializedAdditionalRawData, SentimentResult results) : base(kind, serializedAdditionalRawData)
        {
            Results = results;
        }

        /// <summary> Initializes a new instance of <see cref="AnalyzeTextSentimentResult"/> for deserialization. </summary>
        internal AnalyzeTextSentimentResult()
        {
        }

        /// <summary> The sentiment analysis results. </summary>
        public SentimentResult Results { get; }
    }
}
