// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.Language.Text
{
    /// <summary> The kind of the response object returned by the analyze-text task. </summary>
    internal readonly partial struct AnalyzeTextResultsKind : IEquatable<AnalyzeTextResultsKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AnalyzeTextResultsKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AnalyzeTextResultsKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SentimentAnalysisResultsValue = "SentimentAnalysisResults";
        private const string EntityRecognitionResultsValue = "EntityRecognitionResults";
        private const string PiiEntityRecognitionResultsValue = "PiiEntityRecognitionResults";
        private const string KeyPhraseExtractionResultsValue = "KeyPhraseExtractionResults";
        private const string LanguageDetectionResultsValue = "LanguageDetectionResults";
        private const string EntityLinkingResultsValue = "EntityLinkingResults";
        private const string DynamicClassificationResultsValue = "DynamicClassificationResults";

        /// <summary> Sentiment analysis results. </summary>
        public static AnalyzeTextResultsKind SentimentAnalysisResults { get; } = new AnalyzeTextResultsKind(SentimentAnalysisResultsValue);
        /// <summary> Entity recognition results. </summary>
        public static AnalyzeTextResultsKind EntityRecognitionResults { get; } = new AnalyzeTextResultsKind(EntityRecognitionResultsValue);
        /// <summary> PII entity recognition results. </summary>
        public static AnalyzeTextResultsKind PiiEntityRecognitionResults { get; } = new AnalyzeTextResultsKind(PiiEntityRecognitionResultsValue);
        /// <summary> Key phrase extraction results. </summary>
        public static AnalyzeTextResultsKind KeyPhraseExtractionResults { get; } = new AnalyzeTextResultsKind(KeyPhraseExtractionResultsValue);
        /// <summary> Language detection results. </summary>
        public static AnalyzeTextResultsKind LanguageDetectionResults { get; } = new AnalyzeTextResultsKind(LanguageDetectionResultsValue);
        /// <summary> Entity linking results. </summary>
        public static AnalyzeTextResultsKind EntityLinkingResults { get; } = new AnalyzeTextResultsKind(EntityLinkingResultsValue);
        /// <summary> Dynamic classification results. </summary>
        public static AnalyzeTextResultsKind DynamicClassificationResults { get; } = new AnalyzeTextResultsKind(DynamicClassificationResultsValue);
        /// <summary> Determines if two <see cref="AnalyzeTextResultsKind"/> values are the same. </summary>
        public static bool operator ==(AnalyzeTextResultsKind left, AnalyzeTextResultsKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AnalyzeTextResultsKind"/> values are not the same. </summary>
        public static bool operator !=(AnalyzeTextResultsKind left, AnalyzeTextResultsKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AnalyzeTextResultsKind"/>. </summary>
        public static implicit operator AnalyzeTextResultsKind(string value) => new AnalyzeTextResultsKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AnalyzeTextResultsKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AnalyzeTextResultsKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
