// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Text
{
    /// <summary> Contains the analyze text PIIEntityRecognition LRO task. </summary>
    public partial class AnalyzeTextPiiResult : AnalyzeTextResult
    {
        /// <summary> Initializes a new instance of <see cref="AnalyzeTextPiiResult"/>. </summary>
        /// <param name="results"> The list of pii results. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="results"/> is null. </exception>
        internal AnalyzeTextPiiResult(PiiResult results)
        {
            Argument.AssertNotNull(results, nameof(results));

            Kind = AnalyzeTextResultsKind.PiiEntityRecognitionResults;
            Results = results;
        }

        /// <summary> Initializes a new instance of <see cref="AnalyzeTextPiiResult"/>. </summary>
        /// <param name="kind"> The kind of task result. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="results"> The list of pii results. </param>
        internal AnalyzeTextPiiResult(AnalyzeTextResultsKind kind, IDictionary<string, BinaryData> serializedAdditionalRawData, PiiResult results) : base(kind, serializedAdditionalRawData)
        {
            Results = results;
        }

        /// <summary> Initializes a new instance of <see cref="AnalyzeTextPiiResult"/> for deserialization. </summary>
        internal AnalyzeTextPiiResult()
        {
        }

        /// <summary> The list of pii results. </summary>
        public PiiResult Results { get; }
    }
}
