// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.Language.Text
{
    /// <summary> The kind of the response object returned by the analyze-text long running task. </summary>
    internal readonly partial struct AnalyzeTextOperationResultsKind : IEquatable<AnalyzeTextOperationResultsKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AnalyzeTextOperationResultsKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AnalyzeTextOperationResultsKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SentimentAnalysisOperationResultsValue = "SentimentAnalysisLROResults";
        private const string EntityRecognitionOperationResultsValue = "EntityRecognitionLROResults";
        private const string PiiEntityRecognitionOperationResultsValue = "PiiEntityRecognitionLROResults";
        private const string KeyPhraseExtractionOperationResultsValue = "KeyPhraseExtractionLROResults";
        private const string EntityLinkingOperationResultsValue = "EntityLinkingLROResults";
        private const string HealthcareOperationResultsValue = "HealthcareLROResults";
        private const string CustomEntityRecognitionOperationResultsValue = "CustomEntityRecognitionLROResults";
        private const string CustomSingleLabelClassificationOperationResultsValue = "CustomSingleLabelClassificationLROResults";
        private const string CustomMultiLabelClassificationOperationResultsValue = "CustomMultiLabelClassificationLROResults";
        private const string ExtractiveSummarizationOperationResultsValue = "ExtractiveSummarizationLROResults";
        private const string AbstractiveSummarizationOperationResultsValue = "AbstractiveSummarizationLROResults";
        private const string CustomHealthcareOperationResultsValue = "CustomHealthcareLROResults";
        private const string CustomSentimentAnalysisOperationResultsValue = "CustomSentimentAnalysisLROResults";
        private const string CustomAbstractiveSummarizationOperationResultsValue = "CustomAbstractiveSummarizationLROResults";

        /// <summary> Sentiment analysis LRO results. </summary>
        public static AnalyzeTextOperationResultsKind SentimentAnalysisOperationResults { get; } = new AnalyzeTextOperationResultsKind(SentimentAnalysisOperationResultsValue);
        /// <summary> Entity recognition LRO results. </summary>
        public static AnalyzeTextOperationResultsKind EntityRecognitionOperationResults { get; } = new AnalyzeTextOperationResultsKind(EntityRecognitionOperationResultsValue);
        /// <summary> PII entity recognition LRO results. </summary>
        public static AnalyzeTextOperationResultsKind PiiEntityRecognitionOperationResults { get; } = new AnalyzeTextOperationResultsKind(PiiEntityRecognitionOperationResultsValue);
        /// <summary> Key phrase extraction LRO results. </summary>
        public static AnalyzeTextOperationResultsKind KeyPhraseExtractionOperationResults { get; } = new AnalyzeTextOperationResultsKind(KeyPhraseExtractionOperationResultsValue);
        /// <summary> Entity linking LRO results. </summary>
        public static AnalyzeTextOperationResultsKind EntityLinkingOperationResults { get; } = new AnalyzeTextOperationResultsKind(EntityLinkingOperationResultsValue);
        /// <summary> Healthcare LRO results. </summary>
        public static AnalyzeTextOperationResultsKind HealthcareOperationResults { get; } = new AnalyzeTextOperationResultsKind(HealthcareOperationResultsValue);
        /// <summary> Custom entity recognition LRO results. </summary>
        public static AnalyzeTextOperationResultsKind CustomEntityRecognitionOperationResults { get; } = new AnalyzeTextOperationResultsKind(CustomEntityRecognitionOperationResultsValue);
        /// <summary> Custom single label classification LRO results. </summary>
        public static AnalyzeTextOperationResultsKind CustomSingleLabelClassificationOperationResults { get; } = new AnalyzeTextOperationResultsKind(CustomSingleLabelClassificationOperationResultsValue);
        /// <summary> Custom multi label classification LRO results. </summary>
        public static AnalyzeTextOperationResultsKind CustomMultiLabelClassificationOperationResults { get; } = new AnalyzeTextOperationResultsKind(CustomMultiLabelClassificationOperationResultsValue);
        /// <summary> Extractive summarization LRO results. </summary>
        public static AnalyzeTextOperationResultsKind ExtractiveSummarizationOperationResults { get; } = new AnalyzeTextOperationResultsKind(ExtractiveSummarizationOperationResultsValue);
        /// <summary> Abstractive summarization LRO results. </summary>
        public static AnalyzeTextOperationResultsKind AbstractiveSummarizationOperationResults { get; } = new AnalyzeTextOperationResultsKind(AbstractiveSummarizationOperationResultsValue);
        /// <summary> Custom healthcare LRO results. </summary>
        public static AnalyzeTextOperationResultsKind CustomHealthcareOperationResults { get; } = new AnalyzeTextOperationResultsKind(CustomHealthcareOperationResultsValue);
        /// <summary> Custom sentiment analysis LRO results. </summary>
        public static AnalyzeTextOperationResultsKind CustomSentimentAnalysisOperationResults { get; } = new AnalyzeTextOperationResultsKind(CustomSentimentAnalysisOperationResultsValue);
        /// <summary> Custom abstractive summarization LRO results. </summary>
        public static AnalyzeTextOperationResultsKind CustomAbstractiveSummarizationOperationResults { get; } = new AnalyzeTextOperationResultsKind(CustomAbstractiveSummarizationOperationResultsValue);
        /// <summary> Determines if two <see cref="AnalyzeTextOperationResultsKind"/> values are the same. </summary>
        public static bool operator ==(AnalyzeTextOperationResultsKind left, AnalyzeTextOperationResultsKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AnalyzeTextOperationResultsKind"/> values are not the same. </summary>
        public static bool operator !=(AnalyzeTextOperationResultsKind left, AnalyzeTextOperationResultsKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AnalyzeTextOperationResultsKind"/>. </summary>
        public static implicit operator AnalyzeTextOperationResultsKind(string value) => new AnalyzeTextOperationResultsKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AnalyzeTextOperationResultsKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AnalyzeTextOperationResultsKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
