// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.Language.Text
{
    /// <summary> The kind of the long running analyze text tasks supported. </summary>
    internal readonly partial struct AnalyzeTextOperationActionKind : IEquatable<AnalyzeTextOperationActionKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AnalyzeTextOperationActionKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AnalyzeTextOperationActionKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SentimentAnalysisValue = "SentimentAnalysis";
        private const string EntityRecognitionValue = "EntityRecognition";
        private const string PiiEntityRecognitionValue = "PiiEntityRecognition";
        private const string KeyPhraseExtractionValue = "KeyPhraseExtraction";
        private const string EntityLinkingValue = "EntityLinking";
        private const string HealthcareValue = "Healthcare";
        private const string CustomEntityRecognitionValue = "CustomEntityRecognition";
        private const string CustomSingleLabelClassificationValue = "CustomSingleLabelClassification";
        private const string CustomMultiLabelClassificationValue = "CustomMultiLabelClassification";
        private const string ExtractiveSummarizationValue = "ExtractiveSummarization";
        private const string AbstractiveSummarizationValue = "AbstractiveSummarization";
        private const string CustomHealthcareValue = "CustomHealthcare";
        private const string CustomSentimentAnalysisValue = "CustomSentimentAnalysis";
        private const string CustomAbstractiveSummarizationValue = "CustomAbstractiveSummarization";

        /// <summary> Sentiment analysis task. </summary>
        public static AnalyzeTextOperationActionKind SentimentAnalysis { get; } = new AnalyzeTextOperationActionKind(SentimentAnalysisValue);
        /// <summary> Entity recognition task. </summary>
        public static AnalyzeTextOperationActionKind EntityRecognition { get; } = new AnalyzeTextOperationActionKind(EntityRecognitionValue);
        /// <summary> PII entity recognition task. </summary>
        public static AnalyzeTextOperationActionKind PiiEntityRecognition { get; } = new AnalyzeTextOperationActionKind(PiiEntityRecognitionValue);
        /// <summary> Key phrase extraction task. </summary>
        public static AnalyzeTextOperationActionKind KeyPhraseExtraction { get; } = new AnalyzeTextOperationActionKind(KeyPhraseExtractionValue);
        /// <summary> Entity linking task. </summary>
        public static AnalyzeTextOperationActionKind EntityLinking { get; } = new AnalyzeTextOperationActionKind(EntityLinkingValue);
        /// <summary> Healthcare task. </summary>
        public static AnalyzeTextOperationActionKind Healthcare { get; } = new AnalyzeTextOperationActionKind(HealthcareValue);
        /// <summary> Custom entity recognition task. </summary>
        public static AnalyzeTextOperationActionKind CustomEntityRecognition { get; } = new AnalyzeTextOperationActionKind(CustomEntityRecognitionValue);
        /// <summary> Custom single label classification task. </summary>
        public static AnalyzeTextOperationActionKind CustomSingleLabelClassification { get; } = new AnalyzeTextOperationActionKind(CustomSingleLabelClassificationValue);
        /// <summary> Custom multi label classification task. </summary>
        public static AnalyzeTextOperationActionKind CustomMultiLabelClassification { get; } = new AnalyzeTextOperationActionKind(CustomMultiLabelClassificationValue);
        /// <summary> Extractive summarization task. </summary>
        public static AnalyzeTextOperationActionKind ExtractiveSummarization { get; } = new AnalyzeTextOperationActionKind(ExtractiveSummarizationValue);
        /// <summary> Abstractive summarization task. </summary>
        public static AnalyzeTextOperationActionKind AbstractiveSummarization { get; } = new AnalyzeTextOperationActionKind(AbstractiveSummarizationValue);
        /// <summary> Custom healthcare task. </summary>
        public static AnalyzeTextOperationActionKind CustomHealthcare { get; } = new AnalyzeTextOperationActionKind(CustomHealthcareValue);
        /// <summary> Custom sentiment analysis task. </summary>
        public static AnalyzeTextOperationActionKind CustomSentimentAnalysis { get; } = new AnalyzeTextOperationActionKind(CustomSentimentAnalysisValue);
        /// <summary> Custom abstractive summarization task. </summary>
        public static AnalyzeTextOperationActionKind CustomAbstractiveSummarization { get; } = new AnalyzeTextOperationActionKind(CustomAbstractiveSummarizationValue);
        /// <summary> Determines if two <see cref="AnalyzeTextOperationActionKind"/> values are the same. </summary>
        public static bool operator ==(AnalyzeTextOperationActionKind left, AnalyzeTextOperationActionKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AnalyzeTextOperationActionKind"/> values are not the same. </summary>
        public static bool operator !=(AnalyzeTextOperationActionKind left, AnalyzeTextOperationActionKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AnalyzeTextOperationActionKind"/>. </summary>
        public static implicit operator AnalyzeTextOperationActionKind(string value) => new AnalyzeTextOperationActionKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AnalyzeTextOperationActionKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AnalyzeTextOperationActionKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
