// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Text
{
    /// <summary> Contains the language detection task result for the request. </summary>
    public partial class AnalyzeTextLanguageDetectionResult : AnalyzeTextResult
    {
        /// <summary> Initializes a new instance of <see cref="AnalyzeTextLanguageDetectionResult"/>. </summary>
        /// <param name="results"> Contains the language detection results. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="results"/> is null. </exception>
        internal AnalyzeTextLanguageDetectionResult(LanguageDetectionResult results)
        {
            Argument.AssertNotNull(results, nameof(results));

            Kind = AnalyzeTextResultsKind.LanguageDetectionResults;
            Results = results;
        }

        /// <summary> Initializes a new instance of <see cref="AnalyzeTextLanguageDetectionResult"/>. </summary>
        /// <param name="kind"> The kind of task result. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="results"> Contains the language detection results. </param>
        internal AnalyzeTextLanguageDetectionResult(AnalyzeTextResultsKind kind, IDictionary<string, BinaryData> serializedAdditionalRawData, LanguageDetectionResult results) : base(kind, serializedAdditionalRawData)
        {
            Results = results;
        }

        /// <summary> Initializes a new instance of <see cref="AnalyzeTextLanguageDetectionResult"/> for deserialization. </summary>
        internal AnalyzeTextLanguageDetectionResult()
        {
        }

        /// <summary> Contains the language detection results. </summary>
        public LanguageDetectionResult Results { get; }
    }
}
