// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Text
{
    /// <summary> Contains the analyze text KeyPhraseExtraction task result. </summary>
    public partial class AnalyzeTextKeyPhraseResult : AnalyzeTextResult
    {
        /// <summary> Initializes a new instance of <see cref="AnalyzeTextKeyPhraseResult"/>. </summary>
        /// <param name="results"> The list of Key phrase extraction results. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="results"/> is null. </exception>
        internal AnalyzeTextKeyPhraseResult(KeyPhraseResult results)
        {
            Argument.AssertNotNull(results, nameof(results));

            Kind = AnalyzeTextResultsKind.KeyPhraseExtractionResults;
            Results = results;
        }

        /// <summary> Initializes a new instance of <see cref="AnalyzeTextKeyPhraseResult"/>. </summary>
        /// <param name="kind"> The kind of task result. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="results"> The list of Key phrase extraction results. </param>
        internal AnalyzeTextKeyPhraseResult(AnalyzeTextResultsKind kind, IDictionary<string, BinaryData> serializedAdditionalRawData, KeyPhraseResult results) : base(kind, serializedAdditionalRawData)
        {
            Results = results;
        }

        /// <summary> Initializes a new instance of <see cref="AnalyzeTextKeyPhraseResult"/> for deserialization. </summary>
        internal AnalyzeTextKeyPhraseResult()
        {
        }

        /// <summary> The list of Key phrase extraction results. </summary>
        public KeyPhraseResult Results { get; }
    }
}
