// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.Language.Text
{
    /// <summary> The kind of the analyze-text tasks supported. </summary>
    internal readonly partial struct AnalyzeTextInputKind : IEquatable<AnalyzeTextInputKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AnalyzeTextInputKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AnalyzeTextInputKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SentimentAnalysisValue = "SentimentAnalysis";
        private const string EntityRecognitionValue = "EntityRecognition";
        private const string PiiEntityRecognitionValue = "PiiEntityRecognition";
        private const string KeyPhraseExtractionValue = "KeyPhraseExtraction";
        private const string LanguageDetectionValue = "LanguageDetection";
        private const string EntityLinkingValue = "EntityLinking";
        private const string DynamicClassificationValue = "DynamicClassification";

        /// <summary> Sentiment analysis task. </summary>
        public static AnalyzeTextInputKind SentimentAnalysis { get; } = new AnalyzeTextInputKind(SentimentAnalysisValue);
        /// <summary> Entity recognition task. </summary>
        public static AnalyzeTextInputKind EntityRecognition { get; } = new AnalyzeTextInputKind(EntityRecognitionValue);
        /// <summary> PII entity recognition task. </summary>
        public static AnalyzeTextInputKind PiiEntityRecognition { get; } = new AnalyzeTextInputKind(PiiEntityRecognitionValue);
        /// <summary> Key phrase extraction task. </summary>
        public static AnalyzeTextInputKind KeyPhraseExtraction { get; } = new AnalyzeTextInputKind(KeyPhraseExtractionValue);
        /// <summary> Language detection task. </summary>
        public static AnalyzeTextInputKind LanguageDetection { get; } = new AnalyzeTextInputKind(LanguageDetectionValue);
        /// <summary> Entity linking task. </summary>
        public static AnalyzeTextInputKind EntityLinking { get; } = new AnalyzeTextInputKind(EntityLinkingValue);
        /// <summary> Dynamic classification task. </summary>
        public static AnalyzeTextInputKind DynamicClassification { get; } = new AnalyzeTextInputKind(DynamicClassificationValue);
        /// <summary> Determines if two <see cref="AnalyzeTextInputKind"/> values are the same. </summary>
        public static bool operator ==(AnalyzeTextInputKind left, AnalyzeTextInputKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AnalyzeTextInputKind"/> values are not the same. </summary>
        public static bool operator !=(AnalyzeTextInputKind left, AnalyzeTextInputKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AnalyzeTextInputKind"/>. </summary>
        public static implicit operator AnalyzeTextInputKind(string value) => new AnalyzeTextInputKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AnalyzeTextInputKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AnalyzeTextInputKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
