// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.Language.Text
{
    /// <summary> Human-readable error code. </summary>
    public readonly partial struct AnalyzeTextErrorCode : IEquatable<AnalyzeTextErrorCode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AnalyzeTextErrorCode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AnalyzeTextErrorCode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidRequestValue = "InvalidRequest";
        private const string InvalidArgumentValue = "InvalidArgument";
        private const string UnauthorizedValue = "Unauthorized";
        private const string ForbiddenValue = "Forbidden";
        private const string NotFoundValue = "NotFound";
        private const string ProjectNotFoundValue = "ProjectNotFound";
        private const string OperationNotFoundValue = "OperationNotFound";
        private const string AzureCognitiveSearchNotFoundValue = "AzureCognitiveSearchNotFound";
        private const string AzureCognitiveSearchIndexNotFoundValue = "AzureCognitiveSearchIndexNotFound";
        private const string TooManyRequestsValue = "TooManyRequests";
        private const string AzureCognitiveSearchThrottlingValue = "AzureCognitiveSearchThrottling";
        private const string AzureCognitiveSearchIndexLimitReachedValue = "AzureCognitiveSearchIndexLimitReached";
        private const string InternalServerErrorValue = "InternalServerError";
        private const string ServiceUnavailableValue = "ServiceUnavailable";
        private const string TimeoutValue = "Timeout";
        private const string QuotaExceededValue = "QuotaExceeded";
        private const string ConflictValue = "Conflict";
        private const string WarningValue = "Warning";

        /// <summary> Invalid request error. </summary>
        public static AnalyzeTextErrorCode InvalidRequest { get; } = new AnalyzeTextErrorCode(InvalidRequestValue);
        /// <summary> Invalid argument error. </summary>
        public static AnalyzeTextErrorCode InvalidArgument { get; } = new AnalyzeTextErrorCode(InvalidArgumentValue);
        /// <summary> Unauthorized access error. </summary>
        public static AnalyzeTextErrorCode Unauthorized { get; } = new AnalyzeTextErrorCode(UnauthorizedValue);
        /// <summary> Forbidden access error. </summary>
        public static AnalyzeTextErrorCode Forbidden { get; } = new AnalyzeTextErrorCode(ForbiddenValue);
        /// <summary> Not found error. </summary>
        public static AnalyzeTextErrorCode NotFound { get; } = new AnalyzeTextErrorCode(NotFoundValue);
        /// <summary> Project not found error. </summary>
        public static AnalyzeTextErrorCode ProjectNotFound { get; } = new AnalyzeTextErrorCode(ProjectNotFoundValue);
        /// <summary> Operation not found error. </summary>
        public static AnalyzeTextErrorCode OperationNotFound { get; } = new AnalyzeTextErrorCode(OperationNotFoundValue);
        /// <summary> Azure Cognitive Search not found error. </summary>
        public static AnalyzeTextErrorCode AzureCognitiveSearchNotFound { get; } = new AnalyzeTextErrorCode(AzureCognitiveSearchNotFoundValue);
        /// <summary> Azure Cognitive Search index not found error. </summary>
        public static AnalyzeTextErrorCode AzureCognitiveSearchIndexNotFound { get; } = new AnalyzeTextErrorCode(AzureCognitiveSearchIndexNotFoundValue);
        /// <summary> Too many requests error. </summary>
        public static AnalyzeTextErrorCode TooManyRequests { get; } = new AnalyzeTextErrorCode(TooManyRequestsValue);
        /// <summary> Azure Cognitive Search throttling error. </summary>
        public static AnalyzeTextErrorCode AzureCognitiveSearchThrottling { get; } = new AnalyzeTextErrorCode(AzureCognitiveSearchThrottlingValue);
        /// <summary> Azure Cognitive Search index limit reached error. </summary>
        public static AnalyzeTextErrorCode AzureCognitiveSearchIndexLimitReached { get; } = new AnalyzeTextErrorCode(AzureCognitiveSearchIndexLimitReachedValue);
        /// <summary> Internal server error. </summary>
        public static AnalyzeTextErrorCode InternalServerError { get; } = new AnalyzeTextErrorCode(InternalServerErrorValue);
        /// <summary> Service unavailable error. </summary>
        public static AnalyzeTextErrorCode ServiceUnavailable { get; } = new AnalyzeTextErrorCode(ServiceUnavailableValue);
        /// <summary> Timeout error. </summary>
        public static AnalyzeTextErrorCode Timeout { get; } = new AnalyzeTextErrorCode(TimeoutValue);
        /// <summary> Quota exceeded error. </summary>
        public static AnalyzeTextErrorCode QuotaExceeded { get; } = new AnalyzeTextErrorCode(QuotaExceededValue);
        /// <summary> Conflict error. </summary>
        public static AnalyzeTextErrorCode Conflict { get; } = new AnalyzeTextErrorCode(ConflictValue);
        /// <summary> Warning error. </summary>
        public static AnalyzeTextErrorCode Warning { get; } = new AnalyzeTextErrorCode(WarningValue);
        /// <summary> Determines if two <see cref="AnalyzeTextErrorCode"/> values are the same. </summary>
        public static bool operator ==(AnalyzeTextErrorCode left, AnalyzeTextErrorCode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AnalyzeTextErrorCode"/> values are not the same. </summary>
        public static bool operator !=(AnalyzeTextErrorCode left, AnalyzeTextErrorCode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AnalyzeTextErrorCode"/>. </summary>
        public static implicit operator AnalyzeTextErrorCode(string value) => new AnalyzeTextErrorCode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AnalyzeTextErrorCode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AnalyzeTextErrorCode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
