// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Text
{
    /// <summary> Contains the analyze text Entity linking task result. </summary>
    public partial class AnalyzeTextEntityLinkingResult : AnalyzeTextResult
    {
        /// <summary> Initializes a new instance of <see cref="AnalyzeTextEntityLinkingResult"/>. </summary>
        /// <param name="results"> Entity linking result. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="results"/> is null. </exception>
        internal AnalyzeTextEntityLinkingResult(EntityLinkingResult results)
        {
            Argument.AssertNotNull(results, nameof(results));

            Kind = AnalyzeTextResultsKind.EntityLinkingResults;
            Results = results;
        }

        /// <summary> Initializes a new instance of <see cref="AnalyzeTextEntityLinkingResult"/>. </summary>
        /// <param name="kind"> The kind of task result. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="results"> Entity linking result. </param>
        internal AnalyzeTextEntityLinkingResult(AnalyzeTextResultsKind kind, IDictionary<string, BinaryData> serializedAdditionalRawData, EntityLinkingResult results) : base(kind, serializedAdditionalRawData)
        {
            Results = results;
        }

        /// <summary> Initializes a new instance of <see cref="AnalyzeTextEntityLinkingResult"/> for deserialization. </summary>
        internal AnalyzeTextEntityLinkingResult()
        {
        }

        /// <summary> Entity linking result. </summary>
        public EntityLinkingResult Results { get; }
    }
}
