// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Text
{
    /// <summary> Contains the entity task. </summary>
    public partial class AnalyzeTextEntitiesResult : AnalyzeTextResult
    {
        /// <summary> Initializes a new instance of <see cref="AnalyzeTextEntitiesResult"/>. </summary>
        /// <param name="results"> Results for entity recognition. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="results"/> is null. </exception>
        internal AnalyzeTextEntitiesResult(EntitiesResult results)
        {
            Argument.AssertNotNull(results, nameof(results));

            Kind = AnalyzeTextResultsKind.EntityRecognitionResults;
            Results = results;
        }

        /// <summary> Initializes a new instance of <see cref="AnalyzeTextEntitiesResult"/>. </summary>
        /// <param name="kind"> The kind of task result. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="results"> Results for entity recognition. </param>
        internal AnalyzeTextEntitiesResult(AnalyzeTextResultsKind kind, IDictionary<string, BinaryData> serializedAdditionalRawData, EntitiesResult results) : base(kind, serializedAdditionalRawData)
        {
            Results = results;
        }

        /// <summary> Initializes a new instance of <see cref="AnalyzeTextEntitiesResult"/> for deserialization. </summary>
        internal AnalyzeTextEntitiesResult()
        {
        }

        /// <summary> Results for entity recognition. </summary>
        public EntitiesResult Results { get; }
    }
}
