// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Text
{
    /// <summary> Result for Dynamic Classification task. </summary>
    public partial class AnalyzeTextDynamicClassificationResult : AnalyzeTextResult
    {
        /// <summary> Initializes a new instance of <see cref="AnalyzeTextDynamicClassificationResult"/>. </summary>
        /// <param name="results"> Results for Dynamic Classification task. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="results"/> is null. </exception>
        internal AnalyzeTextDynamicClassificationResult(DynamicClassificationResult results)
        {
            Argument.AssertNotNull(results, nameof(results));

            Kind = AnalyzeTextResultsKind.DynamicClassificationResults;
            Results = results;
        }

        /// <summary> Initializes a new instance of <see cref="AnalyzeTextDynamicClassificationResult"/>. </summary>
        /// <param name="kind"> The kind of task result. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="results"> Results for Dynamic Classification task. </param>
        internal AnalyzeTextDynamicClassificationResult(AnalyzeTextResultsKind kind, IDictionary<string, BinaryData> serializedAdditionalRawData, DynamicClassificationResult results) : base(kind, serializedAdditionalRawData)
        {
            Results = results;
        }

        /// <summary> Initializes a new instance of <see cref="AnalyzeTextDynamicClassificationResult"/> for deserialization. </summary>
        internal AnalyzeTextDynamicClassificationResult()
        {
        }

        /// <summary> Results for Dynamic Classification task. </summary>
        public DynamicClassificationResult Results { get; }
    }
}
