// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Text
{
    /// <summary> An object representing the task definition for an Abstractive Summarization task. </summary>
    public partial class AbstractiveSummarizationOperationAction : AnalyzeTextOperationAction
    {
        /// <summary> Initializes a new instance of <see cref="AbstractiveSummarizationOperationAction"/>. </summary>
        public AbstractiveSummarizationOperationAction()
        {
            Kind = AnalyzeTextOperationActionKind.AbstractiveSummarization;
        }

        /// <summary> Initializes a new instance of <see cref="AbstractiveSummarizationOperationAction"/>. </summary>
        /// <param name="name"> task name. </param>
        /// <param name="kind"> The kind of task to perform. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="actionContent"> Parameters for the Abstractive Summarization task. </param>
        internal AbstractiveSummarizationOperationAction(string name, AnalyzeTextOperationActionKind kind, IDictionary<string, BinaryData> serializedAdditionalRawData, AbstractiveSummarizationActionContent actionContent) : base(name, kind, serializedAdditionalRawData)
        {
            ActionContent = actionContent;
        }

        /// <summary> Parameters for the Abstractive Summarization task. </summary>
        public AbstractiveSummarizationActionContent ActionContent { get; set; }
    }
}
