// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.AI.Language.QuestionAnswering
{
    /// <summary> Object to provide the key value pair for each metadata. </summary>
    public partial class MetadataRecord
    {
        /// <summary> Initializes a new instance of <see cref="MetadataRecord"/>. </summary>
        /// <param name="key"> Metadata Key from Metadata dictionary used in the QnA. </param>
        /// <param name="value"> Metadata Value from Metadata dictionary used in the QnA. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="key"/> or <paramref name="value"/> is null. </exception>
        public MetadataRecord(string key, string value)
        {
            Argument.AssertNotNull(key, nameof(key));
            Argument.AssertNotNull(value, nameof(value));

            Key = key;
            Value = value;
        }

        /// <summary> Metadata Key from Metadata dictionary used in the QnA. </summary>
        public string Key { get; }
        /// <summary> Metadata Value from Metadata dictionary used in the QnA. </summary>
        public string Value { get; }
    }
}
