// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.AI.Language.QuestionAnswering
{
    /// <summary> Find QnAs that are associated with the given list of metadata. </summary>
    public partial class MetadataFilter
    {
        /// <summary> Initializes a new instance of <see cref="MetadataFilter"/>. </summary>
        public MetadataFilter()
        {
            Metadata = new ChangeTrackingList<MetadataRecord>();
        }

        /// <summary> Initializes a new instance of <see cref="MetadataFilter"/>. </summary>
        /// <param name="metadata"></param>
        /// <param name="logicalOperation"> Operation used to join metadata filters. </param>
        internal MetadataFilter(IList<MetadataRecord> metadata, LogicalOperationKind? logicalOperation)
        {
            Metadata = metadata;
            LogicalOperation = logicalOperation;
        }

        /// <summary> Gets the metadata. </summary>
        public IList<MetadataRecord> Metadata { get; }
        /// <summary> Operation used to join metadata filters. </summary>
        public LogicalOperationKind? LogicalOperation { get; set; }
    }
}
