// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.AI.Language.QuestionAnswering
{
    /// <summary> Prompt for an answer. </summary>
    public partial class KnowledgeBaseAnswerPrompt
    {
        /// <summary> Initializes a new instance of <see cref="KnowledgeBaseAnswerPrompt"/>. </summary>
        internal KnowledgeBaseAnswerPrompt()
        {
        }

        /// <summary> Initializes a new instance of <see cref="KnowledgeBaseAnswerPrompt"/>. </summary>
        /// <param name="displayOrder"> Index of the prompt - used in ordering of the prompts. </param>
        /// <param name="qnaId"> QnA ID corresponding to the prompt. </param>
        /// <param name="displayText"> Text displayed to represent a follow up question prompt. </param>
        internal KnowledgeBaseAnswerPrompt(int? displayOrder, int? qnaId, string displayText)
        {
            DisplayOrder = displayOrder;
            QnaId = qnaId;
            DisplayText = displayText;
        }

        /// <summary> Index of the prompt - used in ordering of the prompts. </summary>
        public int? DisplayOrder { get; }
        /// <summary> QnA ID corresponding to the prompt. </summary>
        public int? QnaId { get; }
        /// <summary> Text displayed to represent a follow up question prompt. </summary>
        public string DisplayText { get; }
    }
}
