// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;

namespace Azure.AI.Language.QuestionAnswering
{
    public partial class KnowledgeBaseAnswerDialog
    {
        internal static KnowledgeBaseAnswerDialog DeserializeKnowledgeBaseAnswerDialog(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            bool? isContextOnly = default;
            IReadOnlyList<KnowledgeBaseAnswerPrompt> prompts = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("isContextOnly"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isContextOnly = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("prompts"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<KnowledgeBaseAnswerPrompt> array = new List<KnowledgeBaseAnswerPrompt>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(KnowledgeBaseAnswerPrompt.DeserializeKnowledgeBaseAnswerPrompt(item));
                    }
                    prompts = array;
                    continue;
                }
            }
            return new KnowledgeBaseAnswerDialog(isContextOnly, prompts ?? new ChangeTrackingList<KnowledgeBaseAnswerPrompt>());
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static KnowledgeBaseAnswerDialog FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeKnowledgeBaseAnswerDialog(document.RootElement);
        }
    }
}
