// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;

namespace Azure.AI.Language.QuestionAnswering
{
    public partial class AnswersResult
    {
        internal static AnswersResult DeserializeAnswersResult(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IReadOnlyList<KnowledgeBaseAnswer> answers = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("answers"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<KnowledgeBaseAnswer> array = new List<KnowledgeBaseAnswer>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(KnowledgeBaseAnswer.DeserializeKnowledgeBaseAnswer(item));
                    }
                    answers = array;
                    continue;
                }
            }
            return new AnswersResult(answers ?? new ChangeTrackingList<KnowledgeBaseAnswer>());
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static AnswersResult FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeAnswersResult(document.RootElement);
        }
    }
}
