// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using Azure.Core;

namespace Azure.AI.Language.QuestionAnswering
{
    public partial class AnswersOptions : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            if (Optional.IsDefined(QnaId))
            {
                writer.WritePropertyName("qnaId"u8);
                writer.WriteNumberValue(QnaId.Value);
            }
            if (Optional.IsDefined(Question))
            {
                writer.WritePropertyName("question"u8);
                writer.WriteStringValue(Question);
            }
            if (Optional.IsDefined(Size))
            {
                writer.WritePropertyName("top"u8);
                writer.WriteNumberValue(Size.Value);
            }
            if (Optional.IsDefined(UserId))
            {
                writer.WritePropertyName("userId"u8);
                writer.WriteStringValue(UserId);
            }
            if (Optional.IsDefined(ConfidenceThreshold))
            {
                writer.WritePropertyName("confidenceScoreThreshold"u8);
                writer.WriteNumberValue(ConfidenceThreshold.Value);
            }
            if (Optional.IsDefined(AnswerContext))
            {
                writer.WritePropertyName("context"u8);
                writer.WriteObjectValue(AnswerContext);
            }
            if (Optional.IsDefined(RankerKind))
            {
                writer.WritePropertyName("rankerType"u8);
                writer.WriteStringValue(RankerKind.Value.ToString());
            }
            if (Optional.IsDefined(Filters))
            {
                writer.WritePropertyName("filters"u8);
                writer.WriteObjectValue(Filters);
            }
            if (Optional.IsDefined(ShortAnswerOptions))
            {
                writer.WritePropertyName("answerSpanRequest"u8);
                writer.WriteObjectValue(ShortAnswerOptions);
            }
            if (Optional.IsDefined(IncludeUnstructuredSources))
            {
                writer.WritePropertyName("includeUnstructuredSources"u8);
                writer.WriteBooleanValue(IncludeUnstructuredSources.Value);
            }
            writer.WriteEndObject();
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }
    }
}
