// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;

namespace Azure.AI.Language.QuestionAnswering
{
    public partial class AnswersFromTextResult
    {
        internal static AnswersFromTextResult DeserializeAnswersFromTextResult(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IReadOnlyList<TextAnswer> answers = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("answers"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<TextAnswer> array = new List<TextAnswer>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(TextAnswer.DeserializeTextAnswer(item));
                    }
                    answers = array;
                    continue;
                }
            }
            return new AnswersFromTextResult(answers ?? new ChangeTrackingList<TextAnswer>());
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static AnswersFromTextResult FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeAnswersFromTextResult(document.RootElement);
        }
    }
}
