---
page_type: sample
languages:
- csharp
products:
- azure-cognitive-services
- azure-qna-maker
- language-service
name: Azure.AI.Language.QuestionAnswering samples for .NET
description: Samples for the Azure.AI.Language.QuestionAnswering client library
---

# Azure.AI.Language.QuestionAnswering Samples

Question Answering is a cloud-based API service that lets you create a conversational question-and-answer layer over your existing data. Use it to build a knowledge base by extracting questions and answers from your semi-structured content, including FAQ, manuals, and documents. Answer users’ questions with the best answers from the QnAs in your knowledge base—automatically. Your knowledge base gets smarter, too, as it continually learns from user behavior.

- [Ask a question](https://github.com/Azure/azure-sdk-for-net/tree/main/sdk/cognitivelanguage/Azure.AI.Language.QuestionAnswering/samples/Sample1_GetAnswers.md)
- [Ask a follow-up question (chit-chat)](https://github.com/Azure/azure-sdk-for-net/tree/main/sdk/cognitivelanguage/Azure.AI.Language.QuestionAnswering/samples/Sample2_Chat.md)
- [Create and deploy a project](https://github.com/Azure/azure-sdk-for-net/tree/main/sdk/cognitivelanguage/Azure.AI.Language.QuestionAnswering/samples/Sample3_CreateAndDeploy.md)
- [Export and Import a project](https://github.com/Azure/azure-sdk-for-net/tree/main/sdk/cognitivelanguage/Azure.AI.Language.QuestionAnswering/samples/Sample4_ExportAndImport.md)
- [Update Knowledge sources](https://github.com/Azure/azure-sdk-for-net/tree/main/sdk/cognitivelanguage/Azure.AI.Language.QuestionAnswering/samples/Sample5_UpdateKnowledgeSources.md)
