// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Conversations.Models
{
    /// <summary> Represents the weight entity resolution model. </summary>
    public partial class WeightResolution : ResolutionBase
    {
        /// <summary> Initializes a new instance of <see cref="WeightResolution"/>. </summary>
        /// <param name="value"> The numeric value that the extracted text denotes. </param>
        /// <param name="unit"> The weight Unit of measurement. </param>
        internal WeightResolution(double value, WeightUnit unit)
        {
            ResolutionKind = ResolutionKind.WeightResolution;
            Value = value;
            Unit = unit;
        }

        /// <summary> Initializes a new instance of <see cref="WeightResolution"/>. </summary>
        /// <param name="resolutionKind"> The entity resolution object kind. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="value"> The numeric value that the extracted text denotes. </param>
        /// <param name="unit"> The weight Unit of measurement. </param>
        internal WeightResolution(ResolutionKind resolutionKind, IDictionary<string, BinaryData> serializedAdditionalRawData, double value, WeightUnit unit) : base(resolutionKind, serializedAdditionalRawData)
        {
            Value = value;
            Unit = unit;
        }

        /// <summary> Initializes a new instance of <see cref="WeightResolution"/> for deserialization. </summary>
        internal WeightResolution()
        {
        }

        /// <summary> The numeric value that the extracted text denotes. </summary>
        public double Value { get; }
        /// <summary> The weight Unit of measurement. </summary>
        public WeightUnit Unit { get; }
    }
}
