// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Conversations.Models
{
    /// <summary> Represents the volume entity resolution model. </summary>
    public partial class VolumeResolution : ResolutionBase
    {
        /// <summary> Initializes a new instance of <see cref="VolumeResolution"/>. </summary>
        /// <param name="value"> The numeric value that the extracted text denotes. </param>
        /// <param name="unit"> The Volume Unit of measurement. </param>
        internal VolumeResolution(double value, VolumeUnit unit)
        {
            ResolutionKind = ResolutionKind.VolumeResolution;
            Value = value;
            Unit = unit;
        }

        /// <summary> Initializes a new instance of <see cref="VolumeResolution"/>. </summary>
        /// <param name="resolutionKind"> The entity resolution object kind. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="value"> The numeric value that the extracted text denotes. </param>
        /// <param name="unit"> The Volume Unit of measurement. </param>
        internal VolumeResolution(ResolutionKind resolutionKind, IDictionary<string, BinaryData> serializedAdditionalRawData, double value, VolumeUnit unit) : base(resolutionKind, serializedAdditionalRawData)
        {
            Value = value;
            Unit = unit;
        }

        /// <summary> Initializes a new instance of <see cref="VolumeResolution"/> for deserialization. </summary>
        internal VolumeResolution()
        {
        }

        /// <summary> The numeric value that the extracted text denotes. </summary>
        public double Value { get; }
        /// <summary> The Volume Unit of measurement. </summary>
        public VolumeUnit Unit { get; }
    }
}
