// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Conversations.Models
{
    /// <summary> Additional properties for supporting transcript conversation. </summary>
    public partial class TranscriptConversationItem
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="TranscriptConversationItem"/>. </summary>
        /// <param name="id"> The ID of a conversation item. </param>
        /// <param name="participantId"> The participant ID of a conversation item. </param>
        /// <param name="inverseTextNormalized"> Inverse text normalization (ITN) representation of input. The inverse-text-normalized form is the recognized text from Microsoft's speech-to-text API, with phone numbers, numbers, abbreviations, and other transformations applied. </param>
        /// <param name="maskedInverseTextNormalized"> Inverse-text-normalized format with profanity masking applied. </param>
        /// <param name="text"> Display form of the recognized text from the speech-to-text API, with punctuation and capitalization added. </param>
        /// <param name="lexical"> Lexical form of the recognized text from the speech-to-text API, with the actual words recognized. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="id"/>, <paramref name="participantId"/>, <paramref name="inverseTextNormalized"/>, <paramref name="maskedInverseTextNormalized"/>, <paramref name="text"/> or <paramref name="lexical"/> is null. </exception>
        public TranscriptConversationItem(string id, string participantId, string inverseTextNormalized, string maskedInverseTextNormalized, string text, string lexical)
        {
            Argument.AssertNotNull(id, nameof(id));
            Argument.AssertNotNull(participantId, nameof(participantId));
            Argument.AssertNotNull(inverseTextNormalized, nameof(inverseTextNormalized));
            Argument.AssertNotNull(maskedInverseTextNormalized, nameof(maskedInverseTextNormalized));
            Argument.AssertNotNull(text, nameof(text));
            Argument.AssertNotNull(lexical, nameof(lexical));

            Id = id;
            ParticipantId = participantId;
            InverseTextNormalized = inverseTextNormalized;
            MaskedInverseTextNormalized = maskedInverseTextNormalized;
            Text = text;
            Lexical = lexical;
            WordLevelTimings = new ChangeTrackingList<WordLevelTiming>();
        }

        /// <summary> Initializes a new instance of <see cref="TranscriptConversationItem"/>. </summary>
        /// <param name="id"> The ID of a conversation item. </param>
        /// <param name="participantId"> The participant ID of a conversation item. </param>
        /// <param name="language"> The override language of a conversation item in BCP 47 language representation. </param>
        /// <param name="modality"> Enumeration of supported conversational modalities. </param>
        /// <param name="role"> Role of the participant. </param>
        /// <param name="inverseTextNormalized"> Inverse text normalization (ITN) representation of input. The inverse-text-normalized form is the recognized text from Microsoft's speech-to-text API, with phone numbers, numbers, abbreviations, and other transformations applied. </param>
        /// <param name="maskedInverseTextNormalized"> Inverse-text-normalized format with profanity masking applied. </param>
        /// <param name="text"> Display form of the recognized text from the speech-to-text API, with punctuation and capitalization added. </param>
        /// <param name="lexical"> Lexical form of the recognized text from the speech-to-text API, with the actual words recognized. </param>
        /// <param name="wordLevelTimings"> List of word-level audio timing information. </param>
        /// <param name="conversationItemLevelTiming"> Audio timing at the conversation item level. This still can help with AI quality if word-level audio timings are not available. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal TranscriptConversationItem(string id, string participantId, string language, InputModality? modality, ParticipantRole? role, string inverseTextNormalized, string maskedInverseTextNormalized, string text, string lexical, IList<WordLevelTiming> wordLevelTimings, ConversationItemLevelTiming conversationItemLevelTiming, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            ParticipantId = participantId;
            Language = language;
            Modality = modality;
            Role = role;
            InverseTextNormalized = inverseTextNormalized;
            MaskedInverseTextNormalized = maskedInverseTextNormalized;
            Text = text;
            Lexical = lexical;
            WordLevelTimings = wordLevelTimings;
            ConversationItemLevelTiming = conversationItemLevelTiming;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="TranscriptConversationItem"/> for deserialization. </summary>
        internal TranscriptConversationItem()
        {
        }

        /// <summary> The ID of a conversation item. </summary>
        public string Id { get; }
        /// <summary> The participant ID of a conversation item. </summary>
        public string ParticipantId { get; }
        /// <summary> The override language of a conversation item in BCP 47 language representation. </summary>
        public string Language { get; set; }
        /// <summary> Enumeration of supported conversational modalities. </summary>
        public InputModality? Modality { get; set; }
        /// <summary> Role of the participant. </summary>
        public ParticipantRole? Role { get; set; }
        /// <summary> Inverse text normalization (ITN) representation of input. The inverse-text-normalized form is the recognized text from Microsoft's speech-to-text API, with phone numbers, numbers, abbreviations, and other transformations applied. </summary>
        public string InverseTextNormalized { get; }
        /// <summary> Inverse-text-normalized format with profanity masking applied. </summary>
        public string MaskedInverseTextNormalized { get; }
        /// <summary> Display form of the recognized text from the speech-to-text API, with punctuation and capitalization added. </summary>
        public string Text { get; }
        /// <summary> Lexical form of the recognized text from the speech-to-text API, with the actual words recognized. </summary>
        public string Lexical { get; }
        /// <summary> List of word-level audio timing information. </summary>
        public IList<WordLevelTiming> WordLevelTimings { get; }
        /// <summary> Audio timing at the conversation item level. This still can help with AI quality if word-level audio timings are not available. </summary>
        public ConversationItemLevelTiming ConversationItemLevelTiming { get; set; }
    }
}
