// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.AI.Language.Conversations.Models
{
    /// <summary> model for text conversation. </summary>
    public partial class TextConversation : ConversationInput
    {
        /// <summary> Initializes a new instance of <see cref="TextConversation"/>. </summary>
        /// <param name="id"> Unique identifier for the conversation. </param>
        /// <param name="language"> Language of the conversation item in BCP-47 format. </param>
        /// <param name="conversationItems"> Ordered list of text conversation items in the conversation. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="id"/>, <paramref name="language"/> or <paramref name="conversationItems"/> is null. </exception>
        public TextConversation(string id, string language, IEnumerable<TextConversationItem> conversationItems) : base(id, language)
        {
            Argument.AssertNotNull(id, nameof(id));
            Argument.AssertNotNull(language, nameof(language));
            Argument.AssertNotNull(conversationItems, nameof(conversationItems));

            Modality = InputModality.Text;
            ConversationItems = conversationItems.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="TextConversation"/>. </summary>
        /// <param name="id"> Unique identifier for the conversation. </param>
        /// <param name="language"> Language of the conversation item in BCP-47 format. </param>
        /// <param name="modality"> modality. </param>
        /// <param name="domain"> domain. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="conversationItems"> Ordered list of text conversation items in the conversation. </param>
        internal TextConversation(string id, string language, InputModality modality, ConversationDomain? domain, IDictionary<string, BinaryData> serializedAdditionalRawData, IList<TextConversationItem> conversationItems) : base(id, language, modality, domain, serializedAdditionalRawData)
        {
            ConversationItems = conversationItems;
        }

        /// <summary> Initializes a new instance of <see cref="TextConversation"/> for deserialization. </summary>
        internal TextConversation()
        {
        }

        /// <summary> Ordered list of text conversation items in the conversation. </summary>
        public IList<TextConversationItem> ConversationItems { get; }
    }
}
