// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Conversations.Models
{
    /// <summary> represents the resolution of a date and/or time span. </summary>
    public partial class TemporalSpanResolution : ResolutionBase
    {
        /// <summary> Initializes a new instance of <see cref="TemporalSpanResolution"/>. </summary>
        internal TemporalSpanResolution()
        {
            ResolutionKind = ResolutionKind.TemporalSpanResolution;
        }

        /// <summary> Initializes a new instance of <see cref="TemporalSpanResolution"/>. </summary>
        /// <param name="resolutionKind"> The entity resolution object kind. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="begin"> represents the resolution of a date and/or time span. An extended ISO 8601 date/time representation as described in (https://github.com/Microsoft/Recognizers-Text/blob/master/Patterns/English/English-DateTime.yaml). </param>
        /// <param name="end"> represents the resolution of a date and/or time span. An extended ISO 8601 date/time representation as described in (https://github.com/Microsoft/Recognizers-Text/blob/master/Patterns/English/English-DateTime.yaml). </param>
        /// <param name="duration"> An optional duration value formatted based on the ISO 8601 (https://en.wikipedia.org/wiki/ISO_8601#Durations). </param>
        /// <param name="modifier"> An optional modifier of a date/time instance. </param>
        /// <param name="timex"> An optional triplet containing the beginning, the end, and the duration all stated as ISO 8601 formatted strings. </param>
        internal TemporalSpanResolution(ResolutionKind resolutionKind, IDictionary<string, BinaryData> serializedAdditionalRawData, string begin, string end, string duration, TemporalModifier? modifier, string timex) : base(resolutionKind, serializedAdditionalRawData)
        {
            Begin = begin;
            End = end;
            Duration = duration;
            Modifier = modifier;
            Timex = timex;
        }

        /// <summary> represents the resolution of a date and/or time span. An extended ISO 8601 date/time representation as described in (https://github.com/Microsoft/Recognizers-Text/blob/master/Patterns/English/English-DateTime.yaml). </summary>
        public string Begin { get; }
        /// <summary> represents the resolution of a date and/or time span. An extended ISO 8601 date/time representation as described in (https://github.com/Microsoft/Recognizers-Text/blob/master/Patterns/English/English-DateTime.yaml). </summary>
        public string End { get; }
        /// <summary> An optional duration value formatted based on the ISO 8601 (https://en.wikipedia.org/wiki/ISO_8601#Durations). </summary>
        public string Duration { get; }
        /// <summary> An optional modifier of a date/time instance. </summary>
        public TemporalModifier? Modifier { get; }
        /// <summary> An optional triplet containing the beginning, the end, and the duration all stated as ISO 8601 formatted strings. </summary>
        public string Timex { get; }
    }
}
