// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.Language.Conversations.Models
{
    /// <summary> The temperature Unit of measurement. </summary>
    public readonly partial struct TemperatureUnit : IEquatable<TemperatureUnit>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="TemperatureUnit"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public TemperatureUnit(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnspecifiedValue = "Unspecified";
        private const string FahrenheitValue = "Fahrenheit";
        private const string KelvinValue = "Kelvin";
        private const string RankineValue = "Rankine";
        private const string CelsiusValue = "Celsius";

        /// <summary> Unspecified temperature unit. </summary>
        public static TemperatureUnit Unspecified { get; } = new TemperatureUnit(UnspecifiedValue);
        /// <summary> Fahrenheit temperature unit. </summary>
        public static TemperatureUnit Fahrenheit { get; } = new TemperatureUnit(FahrenheitValue);
        /// <summary> Kelvin temperature unit. </summary>
        public static TemperatureUnit Kelvin { get; } = new TemperatureUnit(KelvinValue);
        /// <summary> Rankine temperature unit. </summary>
        public static TemperatureUnit Rankine { get; } = new TemperatureUnit(RankineValue);
        /// <summary> Celsius temperature unit. </summary>
        public static TemperatureUnit Celsius { get; } = new TemperatureUnit(CelsiusValue);
        /// <summary> Determines if two <see cref="TemperatureUnit"/> values are the same. </summary>
        public static bool operator ==(TemperatureUnit left, TemperatureUnit right) => left.Equals(right);
        /// <summary> Determines if two <see cref="TemperatureUnit"/> values are not the same. </summary>
        public static bool operator !=(TemperatureUnit left, TemperatureUnit right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="TemperatureUnit"/>. </summary>
        public static implicit operator TemperatureUnit(string value) => new TemperatureUnit(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is TemperatureUnit other && Equals(other);
        /// <inheritdoc />
        public bool Equals(TemperatureUnit other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
