// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Conversations.Models
{
    /// <summary> Summary Result Item. </summary>
    public partial class SummaryResultItem
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SummaryResultItem"/>. </summary>
        /// <param name="aspect"> aspect. </param>
        /// <param name="text"> text. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="aspect"/> or <paramref name="text"/> is null. </exception>
        internal SummaryResultItem(string aspect, string text)
        {
            Argument.AssertNotNull(aspect, nameof(aspect));
            Argument.AssertNotNull(text, nameof(text));

            Aspect = aspect;
            Text = text;
            Contexts = new ChangeTrackingList<ItemizedSummaryContext>();
        }

        /// <summary> Initializes a new instance of <see cref="SummaryResultItem"/>. </summary>
        /// <param name="aspect"> aspect. </param>
        /// <param name="text"> text. </param>
        /// <param name="contexts"> Context list of the summary. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SummaryResultItem(string aspect, string text, IReadOnlyList<ItemizedSummaryContext> contexts, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Aspect = aspect;
            Text = text;
            Contexts = contexts;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="SummaryResultItem"/> for deserialization. </summary>
        internal SummaryResultItem()
        {
        }

        /// <summary> aspect. </summary>
        public string Aspect { get; }
        /// <summary> text. </summary>
        public string Text { get; }
        /// <summary> Context list of the summary. </summary>
        public IReadOnlyList<ItemizedSummaryContext> Contexts { get; }
    }
}
