// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Conversations.Models
{
    /// <summary> Result for the summarization task on the conversation. </summary>
    public partial class SummarizationOperationResult : AnalyzeConversationOperationResult
    {
        /// <summary> Initializes a new instance of <see cref="SummarizationOperationResult"/>. </summary>
        /// <param name="lastUpdateDateTime"> The last updated time in UTC for the task. </param>
        /// <param name="status"> The status of the task at the mentioned last update time. </param>
        /// <param name="results"> results. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="results"/> is null. </exception>
        internal SummarizationOperationResult(DateTimeOffset lastUpdateDateTime, ConversationActionState status, SummaryResult results) : base(lastUpdateDateTime, status)
        {
            Argument.AssertNotNull(results, nameof(results));

            Kind = AnalyzeConversationOperationResultsKind.SummarizationOperationResults;
            Results = results;
        }

        /// <summary> Initializes a new instance of <see cref="SummarizationOperationResult"/>. </summary>
        /// <param name="lastUpdateDateTime"> The last updated time in UTC for the task. </param>
        /// <param name="status"> The status of the task at the mentioned last update time. </param>
        /// <param name="name"> task name. </param>
        /// <param name="kind"> discriminator kind. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="results"> results. </param>
        internal SummarizationOperationResult(DateTimeOffset lastUpdateDateTime, ConversationActionState status, string name, AnalyzeConversationOperationResultsKind kind, IDictionary<string, BinaryData> serializedAdditionalRawData, SummaryResult results) : base(lastUpdateDateTime, status, name, kind, serializedAdditionalRawData)
        {
            Results = results;
        }

        /// <summary> Initializes a new instance of <see cref="SummarizationOperationResult"/> for deserialization. </summary>
        internal SummarizationOperationResult()
        {
        }

        /// <summary> results. </summary>
        public SummaryResult Results { get; }
    }
}
