// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Conversations.Models
{
    /// <summary> Task definition for conversational summarization. </summary>
    public partial class SummarizationOperationAction : AnalyzeConversationOperationAction
    {
        /// <summary> Initializes a new instance of <see cref="SummarizationOperationAction"/>. </summary>
        public SummarizationOperationAction()
        {
            Kind = AnalyzeConversationOperationActionKind.ConversationalSummarizationTask;
        }

        /// <summary> Initializes a new instance of <see cref="SummarizationOperationAction"/>. </summary>
        /// <param name="name"> task name. </param>
        /// <param name="kind"> Enumeration of supported analysis tasks on a collection of conversations. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="actionContent"> parameters. </param>
        internal SummarizationOperationAction(string name, AnalyzeConversationOperationActionKind kind, IDictionary<string, BinaryData> serializedAdditionalRawData, ConversationSummarizationActionContent actionContent) : base(name, kind, serializedAdditionalRawData)
        {
            ActionContent = actionContent;
        }

        /// <summary> parameters. </summary>
        public ConversationSummarizationActionContent ActionContent { get; set; }
    }
}
