// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Conversations.Models
{
    /// <summary> To configure Answer span prediction feature. </summary>
    public partial class ShortAnswerConfig
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ShortAnswerConfig"/>. </summary>
        public ShortAnswerConfig()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ShortAnswerConfig"/>. </summary>
        /// <param name="enable"> Enable or disable Answer Span prediction. </param>
        /// <param name="confidenceThreshold"> Minimum threshold score required to include an answer span, value ranges from 0 to 1. </param>
        /// <param name="top"> Number of Top answers to be considered for span prediction from 1 to 10. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ShortAnswerConfig(bool? enable, double? confidenceThreshold, int? top, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Enable = enable;
            ConfidenceThreshold = confidenceThreshold;
            Top = top;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Enable or disable Answer Span prediction. </summary>
        public bool? Enable { get; set; }
        /// <summary> Minimum threshold score required to include an answer span, value ranges from 0 to 1. </summary>
        public double? ConfidenceThreshold { get; set; }
        /// <summary> Number of Top answers to be considered for span prediction from 1 to 10. </summary>
        public int? Top { get; set; }
    }
}
